<div class="container content">
  <div class="title-v3 text-center">
    <h2>Contact Us</h2>
    <p>
      Hubungi kami untuk pemesanan atau informasi lebih lanjut mengenai produk kami.<br>
      Kami siap melayani Anda dengan sepenuh hati.
    </p>
  </div>

  <div class="row">
    <div class="col-md-8 col-sm-12">
      <div class="contact-map">
        <div class="maroon-border">
            <?php if($ownerProfile && $ownerProfile->maps): ?>
                <?php echo $ownerProfile->maps; ?>

            <?php endif; ?>
        </div>
      </div>
    </div>

    <div class="col-md-4 col-sm-12">
      <p class="lead padding-bottom-10">
        Ingin mengetahui lebih banyak tentang kami? Silakan kunjungi lokasi atau hubungi kami melalui informasi berikut.
      </p>
      <ul class="list-unstyled contact-list">
        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-home"></i>
            <div>
              <h6>Alamat</h6>
              <p><?php echo e($ownerProfile->address ?? '-'); ?></p>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-phone"></i>
            <div>
              <h6>Telepon</h6>
              <p><?php echo e($ownerUser->phone ?? '-'); ?></p>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-envelope"></i>
            <div>
              <h6>Email</h6>
              <a href="mailto:<?php echo e($ownerUser->email ?? ''); ?>" class="link-black">
                <?php echo e($ownerUser->email ?? '-'); ?>

              </a>
            </div>
          </div>
        </li>

        <li>
          <div class="contact-item">
            <i class="icon-custom icon-sm rounded-x icon-bg-maroon fa fa-instagram"></i>
            <div>
              <h6>Instagram</h6>
              <?php if($ownerProfile && $ownerProfile->instagram): ?>
                <a href="https://instagram.com/<?php echo e(ltrim($ownerProfile->instagram, '@')); ?>" target="_blank" class="link-black">
                  <?php echo e($ownerProfile->instagram); ?>

                </a>
              <?php else: ?>
                -
              <?php endif; ?>
            </div>
          </div>
        </li>
      </ul>
    </div>
  </div>
</div><?php /**PATH C:\PAW\PiaZhang\resources\views/publicpage/partials/_contact.blade.php ENDPATH**/ ?>