
<?php $__env->startSection('title', 'Detail Produksi'); ?>
<?php $__env->startSection('content'); ?>

<div class="container">

    <div class="w-100">

        <div class="mb-3">
            <label class="field-label">Tanggal Produksi</label>
            <input type="text" class="form-control field-value" value="<?php echo e($production->production_date->format('d F Y')); ?>" disabled>
        </div>

        <div class="row">
            <div class="col-md-6 mb-3">
                <label class="field-label">Biaya Bahan (Rp)</label>
                <input type="text" class="form-control field-value" value="<?php echo e(number_format($production->cost_material,0,',','.')); ?>" disabled>
            </div>

            <div class="col-md-6 mb-3">
                <label class="field-label">Biaya Operasional (Rp)</label>
                <input type="text" class="form-control field-value" value="<?php echo e(number_format($production->operational_cost,0,',','.')); ?>" disabled>
            </div>
        </div>

        <div class="mb-3">
            <label class="field-label">Catatan</label>
            <textarea class="form-control field-value" rows="2" disabled><?php echo e($production->notes ?? '-'); ?></textarea>
        </div>

        <h5 class="mt-4">Detail Produk</h5>
        <div class="table-responsive">
            <?php
                $headers = ['Produk', 'Jumlah Diproduksi'];

                $rows = $production->details->map(function($detail) {
                    return [
                        'cols' => [
                            $detail->product->name,
                            $detail->quantity,
                        ]
                    ];
                });
            ?>


            <div class="table-responsive">
                <style>
                    .table .truncate {
                        display: block;
                        max-width: 220px;
                        white-space: nowrap;
                        overflow: hidden;
                        text-overflow: ellipsis;
                    }
                    .table th, .table td { vertical-align: middle; }
                    @media (max-width: 480px) {
                        .table .truncate { white-space: normal; max-width: none; }
                    }
                </style>

                <table class="table table-bordered table-striped">
                    <thead>
                        <tr>
                            <?php $__currentLoopData = $headers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($header); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>

                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr>
                                <?php $__currentLoopData = $row['cols']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $col): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td>
                                        <div class="truncate" title="<?php echo e(strip_tags($col)); ?>">
                                            <?php echo e($col); ?>

                                        </div>
                                    </td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="<?php echo e(count($headers)); ?>" class="text-center text-muted py-3">
                                    No data available.
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="d-flex justify-content-between pe-2 mt-4">
            <?php if (isset($component)) { $__componentOriginalb04da7a8feb93a7268b6e0eef6b32739 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.gold-button','data' => ['onclick' => 'window.location.href=\''.e(route('productions.index')).'\'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('gold-button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['onclick' => 'window.location.href=\''.e(route('productions.index')).'\'']); ?>
                <i class="bi bi-arrow-left"></i> Kembali
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739)): ?>
<?php $attributes = $__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739; ?>
<?php unset($__attributesOriginalb04da7a8feb93a7268b6e0eef6b32739); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalb04da7a8feb93a7268b6e0eef6b32739)): ?>
<?php $component = $__componentOriginalb04da7a8feb93a7268b6e0eef6b32739; ?>
<?php unset($__componentOriginalb04da7a8feb93a7268b6e0eef6b32739); ?>
<?php endif; ?>

            <?php if (isset($component)) { $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['onclick' => 'window.location.href=\''.e(route('productions.edit', $production->id)).'\'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['onclick' => 'window.location.href=\''.e(route('productions.edit', $production->id)).'\'']); ?>
                Edit Produksi
             <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $attributes = $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $component = $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
        </div>

        <div class="text-muted small mt-3">
            Dibuat: <?php echo e($production->created_at?->format('Y-m-d H:i') ?? '-'); ?>

            &nbsp;|&nbsp;
            Diperbarui: <?php echo e($production->updated_at?->format('Y-m-d H:i') ?? '-'); ?>

        </div>

    </div>

</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\PAW\PiaZhang\resources\views/productions/show.blade.php ENDPATH**/ ?>