<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\OrderDetailController;
use App\Http\Controllers\PortofolioController;
use App\Http\Controllers\ProductionController;
use App\Http\Controllers\PublicPageController;
use App\Http\Controllers\ResellerController;
use App\Http\Controllers\ResellerOrderController;
use App\Http\Controllers\ResellerOrderDetailController;
use App\Http\Controllers\ResellerPaymentController;
use App\Http\Controllers\ResellerStockController;
use App\Http\Controllers\ResellerBarterController;
use App\Http\Controllers\ReportController;
use App\Http\Controllers\ResellerPaymentHistoryController;
use App\Http\Controllers\UserController;

// -----------------------
// Halaman publik
// -----------------------
Route::get('/', [PublicPageController::class, 'index'])->name('public.main');

// -----------------------
// Dashboard / admin routes
// -----------------------
Route::middleware(['auth'])->group(function () {

    // Dashboard utama
    Route::get('/dashboard', fn() => view('dashboard'))->name('dashboard');

    // Profile
    Route::middleware(['auth'])->group(function () {
        Route::get('/profile', [ProfileController::class, 'index'])->name('profile.index');
        Route::get('/profile/edit', [ProfileController::class, 'edit'])->name('profile.edit');
        Route::put('/profile', [ProfileController::class, 'update'])->name('profile.update');
    });

    // Resource utama
    Route::resource('products', ProductController::class);
    Route::resource('orders', OrderController::class);
    Route::resource('order-details', OrderDetailController::class);
    Route::resource('portofolios', PortofolioController::class);
    Route::resource('resellers', ResellerController::class);
    Route::resource('productions', ProductionController::class);

    // Reseller-related
    Route::resource('reseller-orders', ResellerOrderController::class);
    Route::resource('reseller-order-details', ResellerOrderDetailController::class);
    Route::resource('reseller-payments', ResellerPaymentController::class);
    Route::resource('reseller-stocks', ResellerStockController::class);
    Route::delete(
        '/reseller-payment-histories/{history}',
        [ResellerPaymentHistoryController::class, 'destroy']
    )->name('reseller-payment-histories.destroy');

    // Halaman tambahan reseller stock
    Route::get('reseller-stocks/reseller-list', [ResellerStockController::class, 'index'])->name('reseller-stocks.index');
    Route::get('reseller-stocks/{reseller}', [ResellerStockController::class, 'show'])->name('reseller-stocks.show');
    Route::put('reseller-stocks/{reseller}', [ResellerStockController::class, 'update'])->name('reseller-stocks.update');

    // Reseller Barters
    Route::prefix('reseller-barters')->group(function() {
        Route::get('/', [ResellerBarterController::class, 'index'])->name('reseller-barters.index');
        Route::get('{reseller}/show', [ResellerBarterController::class, 'show'])->name('reseller-barters.show');
        Route::get('{reseller}/create', [ResellerBarterController::class, 'create'])->name('reseller-barters.create');
        Route::post('{reseller}/store', [ResellerBarterController::class, 'store'])->name('reseller-barters.store');
        Route::get('{barter}/edit', [ResellerBarterController::class, 'edit'])->name('reseller-barters.edit');
        Route::put('{barter}/update', [ResellerBarterController::class, 'update'])->name('reseller-barters.update');
        Route::delete('{barter}/destroy', [ResellerBarterController::class, 'destroy'])->name('reseller-barters.destroy');
    });

    // Halaman tambahan / laporan
    Route::get('/products/produce', fn() => view('products.produce'))->name('products.produce');
    Route::get('/customer-orders', fn() => view('customer-orders.index'))->name('customer-orders.index');
    Route::get('/users', fn() => view('users.index'))->name('users.index');

    Route::get('/resellers/orders', fn() => view('resellers.orders'))->name('resellers.orders');
    Route::get('/resellers/stock', fn() => view('resellers.stock'))->name('resellers.stock');
    Route::get('/resellers/history', fn() => view('resellers.history'))->name('resellers.history');

    Route::get('/reports/daily', fn() => view('reports.daily-sales'))->name('reports.daily-sales');
    Route::get('/reports/reseller-sales', fn() => view('reports.reseller-sales'))->name('reports.reseller-sales');
    Route::get('/reports/central-stock', fn() => view('reports.central-stock'))->name('reports.central-stock');
    Route::get('/reports/reseller-stock', fn() => view('reports.reseller-stock'))->name('reports.reseller-stock');

    // Reports Financial
    Route::get('/reports', [ReportController::class, 'index'])->name('reports.index');
    Route::get('/reports/monthly', [App\Http\Controllers\ReportController::class, 'monthly'])->name('reports.monthly');

    Route::middleware(['auth'])->group(function() {
        Route::resource('users', UserController::class);
    });

});

// -----------------------
// Auth routes (Breeze)
// -----------------------
require __DIR__.'/auth.php';
