@extends('layout.main')
@section('title', 'Tambah Admin')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('users.store') }}" autocomplete="off">
        @csrf

        <input type="text" style="display:none">
        <input type="password" style="display:none">

        <x-input-text
            inRowLabel="Nama"
            name="name"
            required
            placeholder="Masukkan nama admin"
            autocomplete="off"
            :value="old('name')"
            :errorMessage="$errors->first('name')"
        />

        <x-input-text
            inRowLabel="Email"
            name="email"
            type="email"
            required
            placeholder="Masukkan email admin"
            autocomplete="off"
            :value="old('email')"
            :errorMessage="$errors->first('email')"
        />

        <x-input-text
            inRowLabel="Phone"
            name="phone"
            placeholder="Masukkan nomor telepon"
            autocomplete="off"
            :value="old('phone')"
            :errorMessage="$errors->first('phone')"
        />

        <x-input-text
            inRowLabel="Password"
            name="password"
            type="password"
            required
            placeholder="Masukkan password"
            autocomplete="new-password"
            :errorMessage="$errors->first('password')"
        />

        <x-input-text
            inRowLabel="Konfirmasi Password"
            name="password_confirmation"
            type="password"
            required
            placeholder="Ulangi password"
            autocomplete="new-password"
        />

        <div class="d-flex justify-content-between pe-2 mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('users.index') }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Simpan
            </x-button>
        </div>
    </form>
</div>

@endsection
