@extends('layout.main')
@section('title', 'Detail Reseller')
@section('content')

<div class="container">

    <div class="mb-3">
        <label class="field-label">Nama Reseller</label>
        <input type="text" class="form-control field-value" value="{{ $reseller->name }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Nomor Telepon</label>
        <input type="text" class="form-control field-value" value="{{ $reseller->phone }}" disabled>
    </div>

    <div class="mb-3">
        <label class="field-label">Maps (embed / url)</label>
        <textarea class="form-control field-value" rows="2" disabled>{{ $reseller->maps ?? '-' }}</textarea>
    </div>

    <div class="mb-3">
        <label class="field-label">Alamat</label>
        <textarea class="form-control field-value" rows="3" disabled>{{ $reseller->address }}</textarea>
    </div>

    <div class="d-flex justify-content-between pe-2 mt-4">
        <x-gold-button type="button" onclick="window.location.href='{{ route('resellers.index') }}'">
            <i class="bi bi-arrow-left"></i> Kembali
        </x-gold-button>

        <x-button type="button" onclick="window.location.href='{{ route('resellers.edit', $reseller->id) }}'">
            Simpan
        </x-button>
    </div>

    <div class="text-muted small mt-3">
        Dibuat: {{ $reseller->created_at?->format('Y-m-d H:i') ?? '-' }}
        &nbsp;|&nbsp;
        Diperbarui: {{ $reseller->updated_at?->format('Y-m-d H:i') ?? '-' }}
    </div>

</div>

@endsection
