@extends('layout.main')
@section('title', 'Edit Reseller')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('resellers.update', $reseller->id) }}">
        @csrf
        @method('PUT')

        <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

            <div class="w-100">

                <x-input-text
                    inRowLabel="Nama Reseller"
                    name="name"
                    required
                    placeholder="Masukkan nama reseller"
                    :value="old('name', $reseller->name)"
                    :errorMessage="$errors->first('name')"
                />

                <x-input-text
                    inRowLabel="Nomor Telepon"
                    name="phone"
                    placeholder="Masukkan nomor telepon reseller"
                    :value="old('phone', $reseller->phone)"
                    :errorMessage="$errors->first('phone')"
                />

                <x-input-text
                    inRowLabel="Maps (embed / url)"
                    name="maps"
                    placeholder="Masukkan link atau embed maps reseller (opsional)"
                    :value="old('maps', $reseller->maps)"
                    :errorMessage="$errors->first('maps')"
                />

                <x-input-text-area
                    inRowLabel="Alamat"
                    name="address"
                    rows="4"
                    placeholder="Masukkan alamat reseller"
                    :errorMessage="$errors->first('address')"
                    :value="old('address', $reseller->address)"
                />

                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('resellers.index') }}'">
                        <i class="bi bi-arrow-left"></i> Kembali
                    </x-gold-button>

                    <x-button type="submit">
                        Simpan
                    </x-button>
                </div>

            </div>

        </div>
    </form>
</div>

@endsection