@extends('layout.main')
@section('title', 'Laporan Bulanan')

@section('content')

<div class="row mb-3">
    <div class="col-md-12">
        <form method="GET" action="{{ route('reports.monthly') }}" class="row g-3 align-items-end">
            <div class="col-md-6">
                <label class="form-label">Tahun</label>
                <input type="number" name="year" class="form-control" value="{{ $year }}">
            </div>

            <div class="col-md-6">
                <x-button type="submit">Filter</x-button>
            </div>
        </form>
    </div>
</div>

@php
$headers = [
    'Bulan',
    'Total Penjualan',
    'Total Reseller',
    'Total Barter',
    'Biaya Bahan',
    'Biaya Operasional',
    'Total Biaya',
    'Laba Bersih'
];
@endphp

<div class="table-responsive">
<table class="table table-bordered table-striped">
    <thead>
        <tr>
            @foreach ($headers as $header)
                <th>{{ $header }}</th>
            @endforeach
        </tr>
    </thead>

    <tbody>
        @forelse ($months as $m)
        <tr>
            <td>{{ $m['bulan'] }}</td>
            <td>Rp {{ number_format($m['total_penjualan'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['total_reseller'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['total_barter'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['biaya_bahan'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['biaya_operasional'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['total_biaya'],0,',','.') }}</td>
            <td>Rp {{ number_format($m['laba_bersih'],0,',','.') }}</td>
        </tr>
        @empty
        <tr>
            <td colspan="8" class="text-center text-muted py-3">
                No data available.
            </td>
        </tr>
        @endforelse
    </tbody>
</table>
</div>

@endsection
