@extends('layout.main')
@section('title', 'Edit Profile Owner')
@section('content')

<div class="container">

    <form method="POST" action="{{ route('profile.update') }}" autocomplete="off">
        @csrf
        @method('PUT')

        <input type="text" style="display:none">
        <input type="password" style="display:none">

        <x-input-text
            inRowLabel="Nama"
            name="name"
            :value="old('name', $user->name)"
            :errorMessage="$errors->first('name')"
        />

        <x-input-text
            inRowLabel="Email"
            name="email"
            type="email"
            :value="old('email', $user->email)"
            :errorMessage="$errors->first('email')"
        />

        <x-input-text
            inRowLabel="Nomor Telepon"
            name="phone"
            :value="old('phone', $user->phone)"
            :errorMessage="$errors->first('phone')"
        />

        <x-input-text
            inRowLabel="Alamat"
            name="address"
            placeholder="Masukkan alamat"
            :value="old('address', $profile->address)"
            :errorMessage="$errors->first('address')"
        />

        <x-input-text
            inRowLabel="Instagram"
            name="instagram"
            placeholder="@username"
            :value="old('instagram', $profile->instagram)"
            :errorMessage="$errors->first('instagram')"
        />

        <x-input-text
            inRowLabel="Shopee"
            name="shopee"
            placeholder="https://shopee.co.id/namatoko"
            :value="old('shopee', $profile->shopee)"
            :errorMessage="$errors->first('shopee')"
        />

        <x-input-text
            inRowLabel="Tokopedia"
            name="tokopedia"
            placeholder="https://www.tokopedia.com/namatoko"
            :value="old('tokopedia', $profile->tokopedia)"
            :errorMessage="$errors->first('tokopedia')"
        />

        <x-input-text
            inRowLabel="Maps Embed"
            name="maps"
            placeholder="Paste embed maps di sini"
            :value="old('maps', $profile->maps)"
            :errorMessage="$errors->first('maps')"
        />

        <x-input-text
            inRowLabel="Password"
            name="password"
            type="password"
            placeholder="Kosongkan jika tidak ingin mengubah password"
            autocomplete="new-password"
            :errorMessage="$errors->first('password')"
        />

        <x-input-text
            inRowLabel="Konfirmasi Password"
            name="password_confirmation"
            type="password"
            placeholder="Kosongkan jika tidak ingin mengubah password"
            autocomplete="new-password"
        />

        <div class="d-flex justify-content-between pe-2 mt-4">
            <x-gold-button type="button" onclick="window.location.href='{{ route('profile.index') }}'">
                <i class="bi bi-arrow-left"></i> Kembali
            </x-gold-button>

            <x-button type="submit">
                Simpan
            </x-button>
        </div>

    </form>

</div>

@endsection