@extends('layout.main')
@section('title', 'Detail Produk')
@section('content')

<div class="container">
    <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

        {{-- Image / preview --}}
        <div class="text-center p-4 pt-0 d-flex flex-column">
            <div class="upload-box">
                @if($product->image)
                    <img class="preview-img" src="{{ asset($product->image) }}" alt="Product image">
                @else
                    <div style="padding-top:30px">Tidak Ada Gambar</div>
                @endif
            </div>
        </div>

        {{-- Details --}}
        <div class="w-100">

            <div class="mb-3">
                <label class="field-label">Nama Produk</label>
                <input type="text" class="form-control field-value" value="{{ $product->name }}" disabled>
            </div>

            <div class="row">
                <div class="col-md-6 mb-3">
                    <label class="field-label">Harga</label>
                    <input type="text" class="form-control field-value" 
                        value="Rp {{ number_format($product->price,0,',','.') }}" disabled>
                </div>

                <div class="col-md-6 mb-3">
                    <label class="field-label">Harga Reseller</label>
                    <input type="text" class="form-control field-value"
                        value="{{ $product->reseller_price ? 'Rp ' . number_format($product->reseller_price,0,',','.') : '-' }}"
                        disabled>
                </div>
            </div>

            <div class="mb-3">
                <label class="field-label">Deskripsi</label>
                <textarea class="form-control field-value" rows="4" disabled>{{ $product->description }}</textarea>
            </div>

            <div class="mb-3">
                <label class="field-label">Tersedia untuk Reseller</label>
                <input type="text" class="form-control field-value" 
                    value="{{ $product->available_for_reseller ? 'Ya' : 'Tidak' }}" disabled>
            </div>

            <div class="d-flex justify-content-between pe-2 mt-4">
                <x-gold-button type="button" onclick="window.location.href='{{ route('products.index') }}'">
                    <i class="bi bi-arrow-left"></i> Kembali
                </x-gold-button>

                <x-button type="button" onclick="window.location.href='{{ route('products.edit', $product->id) }}'">
                    Edit Produk
                </x-button>
            </div>

        </div>

    </div>
</div>

@endsection
