@extends('layout.main') 
@section('title', 'Tambah Portofolio') 
@section('content')

<div class="container">
    <form method="POST" action="{{ route('portofolios.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="d-flex justify-content-between align-items-start flex-lg-row flex-column">

            <div class="text-center p-4 pt-0 d-flex flex-column">
                
                <label for="image" class="upload-box d-flex flex-column align-items-center justify-content-center">
                    <div id="image-preview">
                        <div id="image-instruction">Upload Foto</div>
                    </div>

                    <img id="preview-img" src="#" alt="Preview">

                    <div id="file-name"></div>
                </label>

                <input 
                    type="file" 
                    name="image" 
                    id="image" 
                    class="d-none" 
                    accept="image/*"
                    onchange="previewImage(event)"
                >

                @error('image')
                    <div class="text-danger mt-1">{{ $message }}</div>
                @enderror

                <button type="button" id="remove-image-btn"
                    class="btn btn-outline-danger remove-btn"
                    style="display:none;"
                    onclick="removeImage()"
                >
                    Hapus File
                </button>
            </div>

            <div class="w-100">

                <x-input-text
                    inRowLabel="Judul"
                    name="title"
                    required
                    placeholder="MAsukkan judul portofolio"
                    :value="old('title')"
                    :errorMessage="$errors->first('title')"
                />

                <x-input-text-area
                    inRowLabel="Deskripsi"
                    name="description"
                    rows="3"
                    required
                    placeholder="Masukkan deskripsi portofolio"
                    :errorMessage="$errors->first('description')"
                />

                <div class="d-flex justify-content-between pe-2 mt-4">
                    <x-gold-button type="button" onclick="window.location.href='{{ route('portofolios.index') }}'">
                        <i class="bi bi-arrow-left"></i> Kembali
                    </x-gold-button>

                    <x-button type="submit">
                        Tambah Portofolio
                    </x-button>
                </div>

            </div>

        </div>
    </form>
</div>

<script>
function previewImage(event) {
    const input = event.target;
    const preview = document.getElementById('preview-img');
    const fileName = document.getElementById('file-name');
    const instruction = document.getElementById('image-instruction');
    const note = document.getElementById('image-note');
    const removeBtn = document.getElementById('remove-image-btn');

    if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = e => {
            preview.src = e.target.result;
            preview.style.display = 'block';
        };
        reader.readAsDataURL(input.files[0]);

        fileName.textContent =
            input.files[0].name.length > 30
                ? input.files[0].name.substring(0, 27) + "..."
                : input.files[0].name;

        instruction.style.display = 'none';
        note.style.display = 'none';
        removeBtn.style.display = 'inline-block';
    } else {
        preview.src = '#';
        preview.style.display = 'none';
        fileName.textContent = '';
        instruction.style.display = 'block';
        note.style.display = 'block';
        removeBtn.style.display = 'none';
    }
}

function removeImage() {
    const input = document.getElementById('image');
    input.value = "";
    previewImage({ target: input });
}
</script>

@endsection
