@extends('layout.main')
@section('title', 'Pesanan')
@section('content')

<div class="row mb-3">
    <div class="col-md-12 d-flex justify-content-start">
        <x-button href="{{ route('orders.create') }}">
            Tambah Pesanan
        </x-button>
    </div>
</div>

<div class="row mb-3">
    <div class="col-md-12">
        <form method="GET" action="{{ route('orders.index') }}" class="row g-3 align-items-end">

            <div class="col-md-3">
                <label class="form-label">Dari Tanggal</label>
                <input type="date"
                       name="start_date"
                       class="form-control"
                       value="{{ $startDate }}">
            </div>

            <div class="col-md-3">
                <label class="form-label">Sampai Tanggal</label>
                <input type="date"
                       name="end_date"
                       class="form-control"
                       value="{{ $endDate }}">
            </div>

            <div class="col-md-3">
                <label class="form-label">Status</label>
                <select name="status" class="form-control">
                    <option value="">Semua Status</option>
                    <option value="pending" {{ request('status')=='pending'?'selected':'' }}>Pending</option>
                    <option value="completed" {{ request('status')=='completed'?'selected':'' }}>Completed</option>
                    <option value="scheduled" {{ request('status')=='scheduled'?'selected':'' }}>Scheduled</option>
                </select>
            </div>

            <div class="col-md-3">
                <x-button type="submit">
                    Filter
                </x-button>
            </div>

        </form>
    </div>
</div>

<div class="row">
    <div class="col-12">
        <x-table :headers="$headers" :rows="$rows" />
    </div>
</div>

@endsection