@extends('layout.main')
@section('title', 'Edit Pesanan')
@section('content')

<div class="container">
    <form method="POST" action="{{ route('orders.update', $order->id) }}">
        @csrf
        @method('PUT')

        <x-input-text
            inRowLabel="Nama Customer"
            name="customer_name"
            required
            placeholder="Masukkan nama customer"
            :value="old('customer_name', $order->customer_name)"
            :errorMessage="$errors->first('customer_name')"
        />

        <x-input-text
            inRowLabel="No. HP Customer"
            name="customer_phone"
            placeholder="Masukkan no. HP customer (opsional)"
            :value="old('customer_phone', $order->customer_phone)"
            :errorMessage="$errors->first('customer_phone')"
        />

        <x-input-select
            inRowLabel="Status"
            name="status"
            :options="['pending'=>'Pending','completed'=>'Completed','scheduled'=>'Scheduled']"
            :value="old('status', $order->status)"
        />

        <div id="pickup-wrapper" style="display:none;">
            <x-input-text
                inRowLabel="Tanggal Ambil"
                name="pickup_date"
                type="date"
                :value="old('pickup_date', $order->pickup_date ? $order->pickup_date->format('Y-m-d') : '')"
                :errorMessage="$errors->first('pickup_date')"
            />
        </div>

        <x-input-text
            inRowLabel="Tanggal Order"
            name="order_date"
            type="date"
            required
            :value="old('order_date', $order->order_date ? $order->order_date->format('Y-m-d') : '')"
            :errorMessage="$errors->first('order_date')"
        />

        <h5 class="mt-4">Products</h5>
        <p class="text-muted">Isi 0 jika tidak dipesan</p>

        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Jumlah</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $product)
                        @php
                            $detail = $order->details->firstWhere('product_id', $product->id);
                        @endphp
                        <tr>
                            <td>
                                {{ $product->name }}
                                (Rp {{ number_format($product->price,0,',','.') }})
                            </td>
                            <td>
                                <input type="number"
                                       name="products[{{ $product->id }}][qty]"
                                       min="0"
                                       class="form-control"
                                       value="{{ old('products.'.$product->id.'.qty', $detail->qty ?? 0) }}">
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="d-flex justify-content-between mt-4">
            <x-gold-button type="button"
                onclick="window.location.href='{{ route('orders.index') }}'">
                Back
            </x-gold-button>

            <x-button type="submit">
                Update Order
            </x-button>
        </div>
    </form>
</div>

<script>
document.addEventListener("DOMContentLoaded", function(){
    const statusSelect = document.querySelector('[name="status"]');
    const pickupWrapper = document.getElementById('pickup-wrapper');

    function togglePickup(){
        pickupWrapper.style.display =
            statusSelect.value === 'scheduled' ? 'block' : 'none';
    }

    togglePickup();
    statusSelect.addEventListener('change', togglePickup);
});
</script>

@endsection