@props([
    'name',
    'label' => null,
    'inRowLabel' => null,
    'value' => old($name),
    'options' => [],   // ['0' => 'Tidak', '1' => 'Ya']
    'required' => false,
    'disabled' => false,
    'class' => '',
])

<style>
    .select-theme {
        background: #f6e4bd !important;
        color: #661b18 !important;
        border: 1px solid #d4af37 !important;
        border-radius: 6px;
        padding: 8px 12px;
        font-size: 15px;
    }

    .select-theme:focus {
        border-color: #c19d2f !important;
        box-shadow: 0 0 0 3px rgba(212, 175, 55, 0.25) !important;
        outline: none !important;
    }

    .label-theme {
        color: #661b18;
        font-weight: 600;
        margin-bottom: 4px;
        display: inline-block;
    }

    .input-error {
        color: #b70000;
        font-size: 14px;
        margin-top: 4px;
    }
</style>


{{-- In-row label --}}
@if ($inRowLabel)
    <div class="row mb-3 align-items-center w-100">
        <label for="{{ $name }}" class="col-lg-2 col-form-label label-theme">
            {{ $inRowLabel }}
        </label>

        <div class="col-lg-10">
            <select
                name="{{ $name }}"
                id="{{ $name }}"
                @if ($required) required @endif
                @if ($disabled) disabled @endif
                class="form-select select-theme {{ $class }}"
                {{ $attributes }}
            >
                @foreach ($options as $optionValue => $optionLabel)
                    <option value="{{ $optionValue }}" {{ (string)$value === (string)$optionValue ? 'selected' : '' }}>
                        {{ $optionLabel }}
                    </option>
                @endforeach
            </select>

            @error($name)
                <div class="input-error">{{ $message }}</div>
            @enderror
        </div>
    </div>

{{-- Normal label --}}
@else
    <div class="mb-3 w-100">
        @if ($label)
            <label for="{{ $name }}" class="label-theme">
                {{ $label }}
            </label>
        @endif

        <select
            name="{{ $name }}"
            id="{{ $name }}"
            @if ($required) required @endif
            @if ($disabled) disabled @endif
            class="form-select select-theme {{ $class }}"
            {{ $attributes }}
        >
            @foreach ($options as $optionValue => $optionLabel)
                <option value="{{ $optionValue }}" {{ (string)$value === (string)$optionValue ? 'selected' : '' }}>
                    {{ $optionLabel }}
                </option>
            @endforeach
        </select>

        @error($name)
            <div class="input-error">{{ $message }}</div>
        @enderror
    </div>
@endif
