<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up()
    {
        DB::statement("ALTER TABLE orders MODIFY status ENUM('pending','completed','scheduled') DEFAULT 'pending'");

        Schema::table('orders', function (Blueprint $table) {
            $table->date('pickup_date')->nullable()->after('order_date');
        });
    }

    public function down()
    {
        DB::statement("ALTER TABLE orders MODIFY status ENUM('pending','completed','cancelled') DEFAULT 'pending'");

        Schema::table('orders', function (Blueprint $table) {
            $table->dropColumn('pickup_date');
        });
    }
};