<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ResellerOrderDetail extends Model
{
    protected $fillable = [
        'reseller_order_id',
        'product_id',
        'qty',
        'price',
    ];

    public function order()
    {
        return $this->belongsTo(ResellerOrder::class, 'reseller_order_id');
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
