<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ResellerBarter extends Model
{
    use HasFactory;

    protected $table = 'reseller_barters';

    protected $fillable = [
        'reseller_id',
        'product_id',
        'qty',
        'date',
        'batch_id',
    ];

    protected $casts = [
        'date' => 'datetime',
    ];

    public function reseller()
    {
        return $this->belongsTo(Reseller::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
}
