<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'customer_name',
        'customer_phone',
        'total_price',
        'status',
        'order_date',
        'pickup_date',
    ];

    protected $casts = [
        'order_date' => 'date',
        'pickup_date' => 'date',
    ];

    public function details()
    {
        return $this->hasMany(OrderDetail::class);
    }
}