<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Reseller;
use App\Models\Portofolio;
use App\Models\OwnerProfile;
use App\Models\User;

class PublicPageController extends Controller
{
    public function index()
    {
        $products = Product::orderBy('id', 'asc')->get();
        $resellers = Reseller::latest()->get();
        $portofolios = Portofolio::orderBy('id', 'asc')->get();

        $ownerUser = User::where('role', 'owner')->first();
        $ownerProfile = $ownerUser ? OwnerProfile::where('user_id', $ownerUser->id)->first() : null;

        return view('publicpage.main', compact(
            'products',
            'resellers',
            'portofolios',
            'ownerUser',
            'ownerProfile'
        ));
    }
}